 ; Ŀ
 ;   Pog/Pag, make a ground line or arc with end blocks as a single pline. 
 ;   Copyright 2005, 2010 by Rocket Software Ltd.                          
 ;   Calls external files Malaya and Misps.                                
 ;   Can serrated knives be considered digital?                            
 ; 

 ; Ŀ
 ;   Pog, make a ground line.                                              
 ;   Arguments: Pa, a start point.                                         
 ;              Pb, an end point.                                          
 ;   Calls nothing, Returns nothing, keeps a low profile.                  
 ; 
 (DEFUN POG (pa pb / dista disc hwid qwid pa0 pa1 pb0 pb1)
  (setq angg (angle pa pb))
  (setq dista (distance pa pb))
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
  (setq disc (misps))
  (setq hwid (* disc 1.5))
  (setq qwid (* disc 0.75))
  (setq pa0 (polar pa (+ angg pi) (* disc 1.5)))
  (setq pa1 (polar pa angg (* disc 1.5)))
  (setq pb0 (polar pa angg (- dista qwid)))
  (setq pb1 (polar pa angg (+ dista qwid)))
  (command "pline" pa0 "h" hwid hwid pa1 "h" 0 0 pb0
           "h" (* disc 0.75) (* disc 0.75)
           "a" "ce" pb pb1 pb0 "h" 0 0 "")
 (princ))
 ; Ŀ
 ;   Pog end.                                                              
 ; 

 ; Ŀ
 ;   Pag, make a ground arc.                                               
 ;   Arguments: Pa, a start point.                                         
 ;              Pb, an end point.                                          
 ;   Calls nothing, Returns nothing, keeps a low profile.                  
 ; 
 (DEFUN PAG (pa pb / dista disc hwid qwid pa0 pa1 pb0 pb1)
  (setq angg (angle pa pb))
  (setq dista (distance pa pb))
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
  (setq disc (misps))
  (setq hwid (* disc 1.5))
  (setq qwid (* disc 0.75))
  (setq pa0 (polar pa (+ angg pi) (* disc 1.5)))
  (setq pa1 (polar pa angg (* disc 1.5)))
  (setq pb0 (polar pa angg (- dista qwid)))
  (setq pb1 (polar pa angg (+ dista qwid)))
  (setq arcang (+ (* (/ 180 pi) (angle pa pb)) 30))
  (command "pline" pa0 "h" hwid hwid pa1
           "h" 0 0 pa1 "a" "d" arcang pb0 "l" pb0
           "h" (* disc 0.75) (* disc 0.75)
           "a" "ce" pb pb1 pb0
           "h" 0 0 "")
 (princ))
 ; Ŀ
 ;   Pag end.                                                              
 ; 

 ; Ŀ
 ;   Poag - install a ground conductor line or arc.                        
 ;   Argument: Oora, draw the conductor as a line ("l") or an arc ("a").   
 ;   Calls either Pog or Pag, and C:Malaya (external).  Returns nothing.   
 ; 
 (DEFUN POAG (oora / *error* osmo clay pa pb enam)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq osmo (getvar "osmode"))
  (setq clay (getvar "clayer"))
  (defun *error* (shk)
   (setvar "osmode" osmo)
   (setvar "clayer" clay)
   (command "undo" "end")
  (princ))
  (setvar "osmode" 512)           ; nearest
  (if c:malaya (malaya "ground"))
  (setq pa (getpoint "Ground Line:"))
  (if (setq enam (car (nentselp pa)))
      (command ".change" enam "" "p" "la" "ground" ""))
  (if (= oora "l")
      (setvar "osmode" 128)           ; perpendicular
      (setvar "osmode" 545))          ; 1 = end, 32 = int, 512 = nearest
  (setq pb (getpoint pa "\nDevice to ground:"))
  (setvar "osmode" 0)
  (if (= oora "l")
      (pog pa pb)
      (pag pa pb))
  (*error*)
 (princ))
 ; Ŀ
 ;   Poag end.                                                             
 ; 

 ; Ŀ
 ;   Pog.                                                                  
 ; 
 (DEFUN C:POG ()
  (poag "l")
 (princ))

 ; Ŀ
 ;   Pag.                                                                  
 ; 
 (DEFUN C:PAG ()
  (poag "a")
 (princ))

(princ)
